<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.876266425 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A725" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA725CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA725INST_RETIRED / $InstructionsPerCycleCortexA725CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA725CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA725STALL_FRONTEND / $FrontendStalledCyclesCortexA725CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA725CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA725STALL_BACKEND / $BackendStalledCyclesCortexA725CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundCortexA725CPU_CYCLES &gt; 0), min((($FrontendBoundCortexA725STALL_SLOT_FRONTEND / (5 * $FrontendBoundCortexA725CPU_CYCLES)) - ($FrontendBoundCortexA725STALL_FRONTEND_FLUSH / $FrontendBoundCortexA725CPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
        <series color="255,0,229" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexA725CPU_CYCLES &gt; 0), min(($BackendBoundCortexA725STALL_SLOT_BACKEND / (5 * $BackendBoundCortexA725CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexA725CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexA725OP_SPEC &gt; 0), min(((1 - ($RetiringCortexA725STALL_SLOT / ($RetiringCortexA725CPU_CYCLES * 5))) * ($RetiringCortexA725OP_RETIRED / $RetiringCortexA725OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
        <series color="0,255,25" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationCortexA725CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationCortexA725OP_SPEC &gt; 0), min((((1 - ($BadSpeculationCortexA725STALL_SLOT / (5 * $BadSpeculationCortexA725CPU_CYCLES))) * (1 - ($BadSpeculationCortexA725OP_RETIRED / $BadSpeculationCortexA725OP_SPEC))) + ($BadSpeculationCortexA725STALL_FRONTEND_FLUSH / $BadSpeculationCortexA725CPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexA725OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexA725OP_RETIRED / $RetiredOperationsPercentageCortexA725OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($FrontendCoreBoundCortexA725STALL_FRONTEND &gt; 0), min(($FrontendCoreBoundCortexA725STALL_FRONTEND_CPUBOUND / $FrontendCoreBoundCortexA725STALL_FRONTEND), 1), 0)" name="Frontend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints related to the instruction fetch latency issues caused by memory access components" expression="if(($FrontendMemoryBoundCortexA725STALL_FRONTEND &gt; 0), min(($FrontendMemoryBoundCortexA725STALL_FRONTEND_MEMBOUND / $FrontendMemoryBoundCortexA725STALL_FRONTEND), 1), 0)" name="Frontend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Core Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation or other machine resteers" expression="if(($FrontendCoreFlushBoundCortexA725STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlushBoundCortexA725STALL_FRONTEND_FLUSH / $FrontendCoreFlushBoundCortexA725STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flush Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Memory Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction cache misses" expression="if(($FrontendMemCacheBoundCortexA725STALL_FRONTEND_MEMBOUND &gt; 0), min((($FrontendMemCacheBoundCortexA725STALL_FRONTEND_L1I + $FrontendMemCacheBoundCortexA725STALL_FRONTEND_MEM) / $FrontendMemCacheBoundCortexA725STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem Cache Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction TLB misses" expression="if(($FrontendMemTLBBoundCortexA725STALL_FRONTEND_MEMBOUND &gt; 0), min(($FrontendMemTLBBoundCortexA725STALL_FRONTEND_TLB / $FrontendMemTLBBoundCortexA725STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem TLB Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Mem Cache Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 1 instruction cache misses" expression="if((($FrontendCacheL1IBoundCortexA725STALL_FRONTEND_L1I + $FrontendCacheL1IBoundCortexA725STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL1IBoundCortexA725STALL_FRONTEND_L1I / ($FrontendCacheL1IBoundCortexA725STALL_FRONTEND_L1I + $FrontendCacheL1IBoundCortexA725STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L1I Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 2 instruction cache misses" expression="if((($FrontendCacheL2IBoundCortexA725STALL_FRONTEND_L1I + $FrontendCacheL2IBoundCortexA725STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL2IBoundCortexA725STALL_FRONTEND_MEM / ($FrontendCacheL2IBoundCortexA725STALL_FRONTEND_L1I + $FrontendCacheL2IBoundCortexA725STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L2I Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA725INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA725L1I_CACHE_REFILL / $L1ICacheMPKICortexA725INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA725L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA725L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA725L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Instruction Unified Cache Effectiveness (Frontend Cache L2I Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache instruction accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2ICacheMPKICortexA725INST_RETIRED &gt; 0), (($L2ICacheMPKICortexA725L2I_CACHE_REFILL / $L2ICacheMPKICortexA725INST_RETIRED) * 1000), 0)" name="L2I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Instruction Unified Cache Effectiveness (Frontend Cache L2I Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache instruction accesses missed to the total number of level 2 cache instruction accesses. This gives an indication of the effectiveness of instruction accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2ICacheMissPercentageCortexA725L2I_CACHE &gt; 0), min(($L2ICacheMissPercentageCortexA725L2I_CACHE_REFILL / $L2ICacheMissPercentageCortexA725L2I_CACHE), 1), 0)" name="L2I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA725INST_RETIRED &gt; 0), (($ITLBMPKICortexA725ITLB_WALK / $ITLBMPKICortexA725INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA725INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA725L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA725INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA725L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA725ITLB_WALK / $ITLBWalkPercentageCortexA725L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkLargePagePercentageCortexA725L1I_TLB &gt; 0), min(($ITLBWalkLargePagePercentageCortexA725ITLB_WALK_LARGE / $ITLBWalkLargePagePercentageCortexA725L1I_TLB), 1), 0)" name="ITLB Walk Large Page Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkSmallPagePercentageCortexA725L1I_TLB &gt; 0), min(($ITLBWalkSmallPagePercentageCortexA725ITLB_WALK_SMALL / $ITLBWalkSmallPagePercentageCortexA725L1I_TLB), 1), 0)" name="ITLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA725L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA725L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA725L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the average depth of the instruction TLB walks for an instruction TLB refill" expression="if(($ITLBWalkAverageDepthOfAccessesCortexA725ITLB_WALK &gt; 0), ($ITLBWalkAverageDepthOfAccessesCortexA725ITLB_STEP / $ITLBWalkAverageDepthOfAccessesCortexA725ITLB_WALK), 0)" name="ITLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the average latency of instruction TLB walks in CPU cycles" expression="if(($ITLBWalkAverageLatencyCortexA725ITLB_WALK &gt; 0), ($ITLBWalkAverageLatencyCortexA725ITLB_WALK_PERCYC / $ITLBWalkAverageLatencyCortexA725ITLB_WALK), 0)" name="ITLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($BackendCoreBoundCortexA725STALL_BACKEND &gt; 0), min(($BackendCoreBoundCortexA725STALL_BACKEND_CPUBOUND / $BackendCoreBoundCortexA725STALL_BACKEND), 1), 0)" name="Backend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints related to memory access latency issues caused by memory access components" expression="if(($BackendMemoryBoundCortexA725STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexA725STALL_BACKEND_MEMBOUND / $BackendMemoryBoundCortexA725STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend as the rename unit registers are unavailable" expression="if(($BackendCoreRenameBoundCortexA725STALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreRenameBoundCortexA725STALL_BACKEND_RENAME / $BackendCoreRenameBoundCortexA725STALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core Rename Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to issue queues being full to accept operations for execution" expression="if(($BackendBusyBoundCortexA725STALL_BACKEND &gt; 0), min(($BackendBusyBoundCortexA725STALL_BACKEND_BUSY / $BackendBusyBoundCortexA725STALL_BACKEND), 1), 0)" name="Backend Busy Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused by data cache misses" expression="if(($BackendMemoryCacheBoundCortexA725STALL_BACKEND_MEMBOUND &gt; 0), min((($BackendMemoryCacheBoundCortexA725STALL_BACKEND_L1D + $BackendMemoryCacheBoundCortexA725STALL_BACKEND_MEM) / $BackendMemoryCacheBoundCortexA725STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Cache Bound" units="percent"/>
        <series color="153,0,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by data TLB misses" expression="if(($BackendMemoryTLBBoundCortexA725STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryTLBBoundCortexA725STALL_BACKEND_TLB / $BackendMemoryTLBBoundCortexA725STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory TLB Bound" units="percent"/>
        <series color="0,255,153" description="This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused by stores stalled in the pre-commit stage" expression="if(($BackendMemoryStoreBoundCortexA725STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryStoreBoundCortexA725STALL_BACKEND_ST / $BackendMemoryStoreBoundCortexA725STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Store Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Cache Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 1 data cache misses" expression="if((($BackendCacheL1DBoundCortexA725STALL_BACKEND_L1D + $BackendCacheL1DBoundCortexA725STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL1DBoundCortexA725STALL_BACKEND_L1D / ($BackendCacheL1DBoundCortexA725STALL_BACKEND_L1D + $BackendCacheL1DBoundCortexA725STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L1D Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 2 data cache misses" expression="if((($BackendCacheL2DBoundCortexA725STALL_BACKEND_L1D + $BackendCacheL2DBoundCortexA725STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL2DBoundCortexA725STALL_BACKEND_MEM / ($BackendCacheL2DBoundCortexA725STALL_BACKEND_L1D + $BackendCacheL2DBoundCortexA725STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L2D Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA725INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA725L1D_CACHE_REFILL / $L1DCacheMPKICortexA725INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA725L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA725L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA725L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Data Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKICortexA725INST_RETIRED &gt; 0), (($L2DCacheMPKICortexA725L2D_CACHE_REFILL / $L2DCacheMPKICortexA725INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Data Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageCortexA725L2D_CACHE &gt; 0), min(($L2DCacheMissPercentageCortexA725L2D_CACHE_REFILL / $L2DCacheMissPercentageCortexA725L2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA725INST_RETIRED &gt; 0), (($L3CacheMPKICortexA725L3D_CACHE_REFILL / $L3CacheMPKICortexA725INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA725L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexA725L3D_CACHE_REFILL / $L3CacheMissPercentageCortexA725L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA725INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA725LL_CACHE_MISS_RD / $LLCacheReadMPKICortexA725INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA725LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA725LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA725LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA725LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA725LL_CACHE_RD - $LLCacheReadHitPercentageCortexA725LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA725LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA725INST_RETIRED &gt; 0), (($DTLBMPKICortexA725DTLB_WALK / $DTLBMPKICortexA725INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA725INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA725L1D_TLB_REFILL / $L1DataTLBMPKICortexA725INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA725INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA725L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA725INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA725L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA725DTLB_WALK / $DTLBWalkPercentageCortexA725L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="255,0,153" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkLargePagePercentageCortexA725L1D_TLB &gt; 0), min(($DTLBWalkLargePagePercentageCortexA725DTLB_WALK_LARGE / $DTLBWalkLargePagePercentageCortexA725L1D_TLB), 1), 0)" name="DTLB Walk Large Page Percentage" units="percent"/>
        <series color="51,0,255" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkSmallPagePercentageCortexA725L1D_TLB &gt; 0), min(($DTLBWalkSmallPagePercentageCortexA725DTLB_WALK_SMALL / $DTLBWalkSmallPagePercentageCortexA725L1D_TLB), 1), 0)" name="DTLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA725L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA725L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA725L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="51,255,0" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA725L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA725L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA725L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the average depth of the data TLB walks for a data TLB refill" expression="if(($DTLBWalkAverageDepthOfAccessesCortexA725DTLB_WALK &gt; 0), ($DTLBWalkAverageDepthOfAccessesCortexA725DTLB_STEP / $DTLBWalkAverageDepthOfAccessesCortexA725DTLB_WALK), 0)" name="DTLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the average latency of data TLB walks in CPU cycles" expression="if(($DTLBWalkAverageLatencyCortexA725DTLB_WALK &gt; 0), ($DTLBWalkAverageLatencyCortexA725DTLB_WALK_PERCYC / $DTLBWalkAverageLatencyCortexA725DTLB_WALK), 0)" name="DTLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Atomics Effectiveness (Backend Memory Bound) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of failed compare and swap instructions speculatively executed locally to the PE that do not update the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearFailPercentageCortexA725CAS_NEAR_SPEC &gt; 0), min((1 - ($CompareAndSwapNearFailPercentageCortexA725CAS_NEAR_PASS / $CompareAndSwapNearFailPercentageCortexA725CAS_NEAR_SPEC)), 1), 0)" name="Compare and Swap Near Fail Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of passed compare and swap instructions speculatively executed locally to the PE that updated the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearPassPercentageCortexA725CAS_NEAR_SPEC &gt; 0), min(($CompareAndSwapNearPassPercentageCortexA725CAS_NEAR_PASS / $CompareAndSwapNearPassPercentageCortexA725CAS_NEAR_SPEC), 1), 0)" name="Compare and Swap Near Pass Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexA725INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexA725ISB_SPEC + $BarrierOperationsPercentageCortexA725DSB_SPEC) + $BarrierOperationsPercentageCortexA725DMB_SPEC) / $BarrierOperationsPercentageCortexA725INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA725INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA725CRYPTO_SPEC / $CryptoOperationsPercentageCortexA725INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA725INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexA725DP_SPEC - $IntegerOperationsPercentageCortexA725DSB_SPEC) / $IntegerOperationsPercentageCortexA725INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA725INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA725VFP_SPEC / $FloatingPointOperationsPercentageCortexA725INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA725INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA725ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA725INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageCortexA725INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageCortexA725SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageCortexA725INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageCortexA725INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageCortexA725FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageCortexA725INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageCortexA725INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageCortexA725FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageCortexA725INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageCortexA725INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageCortexA725FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageCortexA725INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA725INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA725LD_SPEC / $LoadOperationsPercentageCortexA725INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA725INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA725ST_SPEC / $StoreOperationsPercentageCortexA725INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexA725INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexA725RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexA725INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexA725INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexA725RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexA725INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexA725INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexA725STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexA725INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Bad Speculation) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA725INST_RETIRED &gt; 0), (($BranchMPKICortexA725BR_MIS_PRED_RETIRED / $BranchMPKICortexA725INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Bad Speculation) (Cortex-A725)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA725BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA725BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA725BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageCortexA725BR_RETIRED &gt; 0), min(($BranchDirectPercentageCortexA725BR_IMMED_RETIRED / $BranchDirectPercentageCortexA725BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of indirect branches retired, including function returns, to the total number of branches architecturally executed" expression="if(($BranchIndirectPercentageCortexA725BR_RETIRED &gt; 0), min(($BranchIndirectPercentageCortexA725BR_IND_RETIRED / $BranchIndirectPercentageCortexA725BR_RETIRED), 1), 0)" name="Branch Indirect Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageCortexA725BR_RETIRED &gt; 0), min(($BranchReturnPercentageCortexA725BR_RETURN_RETIRED / $BranchReturnPercentageCortexA725BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv9_Cortex_A725_metric_backend_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_core_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_core_rename_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A725_metric_bad_speculation" />
    <select-metric id="ARMv9_Cortex_A725_metric_barrier_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_branch_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_cas_near_fail_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_cas_near_pass_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_crypto_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A725_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A725_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_fp16_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_fp32_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_fp64_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_frontend_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_A725_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A725_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_ipc" />
    <select-metric id="ARMv9_Cortex_A725_metric_itlb_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_A725_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_A725_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_l2d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_l2i_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_l2i_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A725_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Cortex_A725_metric_load_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Cortex_A725_metric_retiring" />
    <select-metric id="ARMv9_Cortex_A725_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_simd_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_store_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_strex_percentage" />
    <select-metric id="ARMv9_Cortex_A725_metric_sve_all_percentage" />
</template>
